CREATE TABLE `tad_idioms` (
  `sn` smallint(6) unsigned NOT NULL AUTO_INCREMENT COMMENT '編號',
  `title` varchar(255) NOT NULL COMMENT '成語',
  `juin` varchar(255) NOT NULL COMMENT '注音',
  `mean` text NOT NULL COMMENT '解釋',
  `show_times` smallint(6) unsigned NOT NULL COMMENT '顯示次數',
  `search_times` smallint(6) unsigned NOT NULL COMMENT '被查詢次數',
  `cate` varchar(255) NOT NULL COMMENT '組別',
  PRIMARY KEY (`sn`)
) ENGINE=MyISAM AUTO_INCREMENT=201 ;

INSERT INTO `tad_idioms` (`sn`, `title`, `juin`, `mean`, `show_times`, `search_times`, `cate`) VALUES
(1, '口若懸河', 'ㄎㄡˇ ㄖㄨㄛˋ ㄒㄩㄢˊ ㄏㄜˊ', '形容人說起話來像瀑布一樣滔滔不絕，比喻人能言善辯。與「笨口拙舌、張口結舌、期期艾艾」相反。', 0, 0, ''),
(2, '千載難逢', 'ㄑㄧㄢ ㄗㄞˇ ㄋㄢˊ ㄈㄥˊ', '載，年的意思。千年也難遇上一次，形容機會極為難得。與「習以為常、司空見慣」相反。', 0, 0, ''),
(3, '一介不取', 'ㄧ ㄐㄧㄝˋ ㄅㄨˋ ㄑㄩˇ', '介，通「芥」，小草，引申微小之物；形容絲毫不取，非常廉潔。', 0, 0, ''),
(4, '一日三秋', 'ㄧ ㄖˋ ㄙㄢ ㄑㄧㄡ', '一天不見，如隔三年。比喻想念殷切。（註：三秋，三年）', 0, 0, ''),
(5, '投桃報李', 'ㄊㄡˊ ㄊㄠˊ ㄅㄠˋ ㄌㄧˇ', '比喻朋友之間友情深重，禮尚往來。', 0, 0, ''),
(6, '防微杜漸', 'ㄈㄤˊ ㄨㄟˊ ㄉㄨˋ ㄐㄧㄢˋ', '微，隱微。杜，堵塞、阻絕。漸，逐漸擴大。在錯誤或壞事萌芽的時候及時制止，杜絕它發展。意指謹慎地防止事物的惡化。', 0, 0, ''),
(7, '宜室宜家', 'ㄧˊ ㄕˋ ㄧˊ ㄐㄧㄚ', '指女子有婦德，能使家庭和樂，夫婦和諧。', 0, 0, ''),
(8, '謙沖自牧', 'ㄑㄧㄢ ㄔㄨㄥ ㄗˋ ㄇㄨˋ', '指人謙虛不自滿。（牧，養）', 0, 0, ''),
(9, '一言九鼎', 'ㄧ ㄧㄢˊ ㄐㄧㄡˇ ㄉㄧㄥˇ', '形容說話具有決定性的作用。（鼎，古代國家的寶器）', 0, 0, ''),
(10, '鴻鵠之志', 'ㄏㄨㄥˊ ㄏㄨˊ ㄓ ㄓˋ', '鴻鵠，天鵝，善高飛；形容遠大的志向，與「燕雀之志」相反。', 0, 0, ''),
(11, '疾風勁草', 'ㄐㄧˊ ㄈㄥ ㄐㄧㄥˋ ㄘㄠˇ', '喻遭遇危難，才知其節操的堅貞。', 0, 0, ''),
(12, '臥薪嘗膽', 'ㄨㄛˋ ㄒㄧㄣ ㄔㄤˊ ㄉㄢˇ', '躺在柴草上嘗苦膽，比喻刻苦發憤的精神。', 0, 0, ''),
(13, '才高八斗', 'ㄘㄞˊ ㄍㄠ ㄅㄚ ㄉㄡˇ', '又作「八斗之才」，比喻才學洋溢，超越眾人。', 0, 0, ''),
(14, '伯樂相馬', 'ㄅㄛˊ ㄌㄜˋ ㄒㄧㄤˋ ㄇㄚˇ', '比喻善於發現、選拔人才。（伯樂，本名孫陽，春秋秦穆公時人，以善於觀察馬著稱）', 0, 0, ''),
(15, '沈魚落雁', 'ㄔㄣˊ ㄩˊ ㄌㄨㄛˋ ㄧㄢˋ', '形容女子容貌美麗出眾。（「閉月羞花」、「國色天香」、「傾國傾城」皆可形容美人）', 0, 0, ''),
(16, '吳下阿蒙', 'ㄨˊ ㄒㄧㄚˋ ㄚˋ ㄇㄥˊ', '用以譏諷人沒有才學。（阿蒙，三國時吳國大將呂蒙）', 0, 0, ''),
(17, '高瞻遠矚', 'ㄍㄠ ㄓㄢ ㄩㄢˇ ㄓㄨˇ', '形容人眼光遠大。（瞻，遠望；矚，注視）', 0, 0, ''),
(18, '光風霽月', 'ㄍㄨㄤ ㄈㄥ ㄐㄧˋ ㄩㄝˋ', '用雨過天晴時的清風明月，比喻人坦蕩高尚的胸懷品格。（光風，雨後初晴時的和風；霽，指雨雪初晴）', 0, 0, ''),
(19, '口碑載道', 'ㄎㄡˇ ㄅㄟ ㄗㄞˋ ㄉㄠˋ', ' 眾人稱頌的話語，就像刻在記功碑上一樣，到處流傳。比喻廣受好評。同「有口皆碑」', 0, 0, ''),
(20, '江郎才盡', 'ㄐㄧㄤ ㄌㄤˊ ㄘㄞˊ ㄐㄧㄣˋ', '南朝文學家江淹，少有文名，晚年文思漸衰。比喻才情文思的減退。', 0, 0, ''),
(21, '行雲流水', 'ㄒㄧㄥˊ ㄩㄣˊ ㄌㄧㄡˊ ㄕㄨㄟˇ', '比喻文章非常自然，毫不呆板。', 0, 0, ''),
(22, '行不由徑', 'ㄒㄧㄥˊ ㄅㄨˋ ㄧㄡˊ ㄐㄧㄥˋ', '走路不走小路。比喻人行事光明正大，心胸坦蕩磊落。', 0, 0, ''),
(23, '文過飾非', 'ㄨㄣˋ ㄍㄨㄛˋ ㄕˋ ㄈㄟ', '文：掩飾。飾：遮掩、偽裝。掩飾過失、錯誤。', 0, 0, ''),
(24, '枕石漱流', 'ㄓㄣˋ ㄕˊ ㄕㄨˋ ㄌㄧㄡˊ', '又作「枕流漱石」。以石為枕，用流水漱口。比喻過隱居的生活，或隱士情志的高潔堅貞。', 0, 0, ''),
(25, '千里鵝毛', 'ㄑㄧㄢ ㄌㄧˇ ㄜˊ ㄇㄠˊ', '喻禮物雖輕但情意甚重。（鵝毛，指物品微薄）', 0, 0, ''),
(26, '鍥而不捨', 'ㄑㄧㄝˋ ㄦˊ ㄅㄨˋ ㄕㄜˇ', '比喻做事持之以恆，堅持不懈。（鍥，雕刻；捨，停止）', 0, 0, ''),
(27, '空穴來風', 'ㄎㄨㄥ ㄒㄩㄝˋ ㄌㄞˊ ㄈㄥ', '比喻事出有因，流言乘隙而入；或比喻憑空捏造不實的傳言。', 0, 0, ''),
(28, '孜孜矻矻', 'ㄗ ㄗ ㄎㄨˋ ㄎㄨˋ', '形容人勤勉努力，不懈怠。意同「孜孜不倦」、「焚膏繼晷」、「夙夜匪懈」。', 0, 0, ''),
(29, '寸草春暉', 'ㄘㄨㄣˋ ㄘㄠˇ ㄔㄨㄣ ㄏㄨㄟ', '比喻父母養育恩情的深重，兒女竭盡心力亦難以回報。（寸草，一寸長的小草，指兒女；春暉，春天溫暖的陽光，指父母對兒女細心的呵護與教養）', 0, 0, ''),
(30, '金蘭之交', 'ㄐㄧㄣ ㄌㄢˊ ㄓ ㄐㄧㄠ', '形容朋友交情的契合。（金，用以比喻其堅；蘭，比喻其香。）與「莫逆之交」、「金石之交」義近。', 0, 0, ''),
(31, '鏡花水月', 'ㄐㄧㄥˋ ㄏㄨㄚ ㄕㄨㄟˇ ㄩㄝˋ', '鏡中的影像，水裡的月亮。比喻虛幻不實在。同「鏡像水月」。', 0, 0, ''),
(32, '讓棗推梨', 'ㄖㄤˋ ㄗㄠˇ ㄊㄨㄟ ㄌㄧˊ', '南朝梁 王泰讓棗，後漢 孔融推梨。用以稱讚兄弟之間友愛。與「兄友弟恭」義近。', 0, 0, ''),
(33, '駑馬十駕', 'ㄋㄨˊ ㄇㄚˇ ㄕˊ ㄐㄧㄚˋ', '駑，劣馬；駕，指馬車一天的行程為一駕。句謂良馬一天能跑千里之遙；劣馬雖慢，只要堅持不懈，也能跑很遠的路程。比喻平庸的人只要勤奮做事，也能有所成就。同「跬步千里」、「勤能補拙」。', 0, 0, ''),
(34, '汲汲營營', 'ㄐㄧˊ ㄐㄧˊ ㄧㄥˊ ㄧㄥˊ', '汲汲，勤求不息；營營，追逐求取。形容人急切地奔馳追逐，以求取功名利祿。', 0, 0, ''),
(35, '一片冰心', 'ㄧ ㄆㄧㄢˋ ㄅㄧㄥ ㄒㄧㄣ', '又作「冰心玉壺」。冰心，心如冰般純潔清明。比喻人不慕名利，心境高潔。', 0, 0, ''),
(36, '蕙質蘭心', 'ㄏㄨㄟˋ ㄓˊ ㄌㄢˊ ㄒㄧㄣ', '又作「蘭質蕙心」。蘭、蕙，皆香草；心靈如蕙，品質如蘭。比喻女子心性聰慧高雅。', 0, 0, ''),
(37, '焚琴煮鶴', 'ㄈㄣˊ ㄑㄧㄣˊ ㄓㄨˇ ㄏㄜˋ', '把琴當柴燒，烹煮鶴來吃。比喻極殺風景的事。', 0, 0, ''),
(38, '班門弄斧', 'ㄅㄢ ㄇㄣˊ ㄋㄨㄥˋ ㄈㄨˇ', '班，魯班，古代春秋魯國巧匠；弄，耍弄。「班門弄斧」指在巧匠魯班門前耍弄大斧。比喻在行家面前賣弄本事，不自量力。與「量力而行、深藏不露」相反。', 0, 0, ''),
(39, '不世之材', 'ㄅㄨˊ ㄕˋ ㄓ ㄘㄞˊ', '不世，世上少有的，非常的。形容當世少有，極出色的人材；是推崇讚譽之詞。同「蓋世之才」（註：蓋世，超過、高出當代之上）。', 0, 0, ''),
(40, '劍及履及', 'ㄐㄧㄢˋ ㄐㄧˊ ㄌㄩˇ ㄐㄧˊ', '履，鞋子，做腳步解。及，到達。比喻奮起速行，指辦事效率極高。', 0, 0, ''),
(41, '運籌帷幄', 'ㄩㄣˋ ㄔㄡˊ ㄨㄟˊ ㄨㄛˋ', '運籌，籌謀策劃；帷幄，古時軍中帳幕。泛指善於策劃或指揮，也用以比喻居幕後策劃。', 0, 0, ''),
(42, '一字千金', 'ㄧ ㄗˋ ㄑㄧㄢ ㄐㄧㄣ', '一個字價值千兩黃金；形容文字價值很高。', 0, 0, ''),
(43, '伯仲之間', 'ㄅㄛˊ ㄓㄨㄥˋ ㄓ ㄐㄧㄢ', '比喻彼此的能力不相上下。（古代兄弟排行：伯仲叔季。以伯仲比喻差距小。）與「一時瑜亮」、「不分軒輊」、「工力悉敵」、「並駕齊驅」意思相當。', 0, 0, ''),
(44, '披星戴月', 'ㄆㄧ ㄒㄧㄥ ㄉㄞˋ ㄩㄝˋ', '形容早出晚歸地辛勤工作。', 0, 0, ''),
(45, '臨深履薄', 'ㄌㄧㄣˊ ㄕㄣ ㄌㄩˇ ㄅㄛˊ', '形容謹慎小心。（詩經：「戰戰兢兢，如臨深淵，如履薄冰」）', 0, 0, ''),
(46, '眾口鑠金', 'ㄓㄨㄥˋ ㄎㄡˇ ㄕㄨㄛˋ ㄐㄧㄣ', '形容輿論力量極大，可以顛倒黑白，混淆是非。（註：鑠，熔化；金，泛指金屬）', 0, 0, ''),
(47, '好整以暇', 'ㄏㄠˋ ㄓㄥˇ ㄧˇ ㄒㄧㄚˊ', '形容人喜愛嚴整而又能從容不迫（註：整，使齊一、有秩序；以，而）；今多用在紛亂、繁忙中顯得從容不迫的樣子。', 0, 0, ''),
(48, '不亢不卑', 'ㄅㄨˋ ㄎㄤˋ ㄅㄨˋ ㄅㄟ', '不高傲也不自卑。（亢：高。）', 0, 0, ''),
(49, '曲突徙薪', 'ㄑㄩ ㄊㄨˊ ㄒㄧˇ ㄒㄧㄣ', '突，煙囪；彎曲煙囪，移開木材。比喻在禍患未發生前，先採取防範措施，則災禍不會發生。同「防患未然」、「未雨綢繆」。', 0, 0, ''),
(50, '未雨綢繆', 'ㄨㄟˋ ㄩˇ ㄔㄡˊ ㄇㄡˊ', '綢繆，緊密纏縛。在未下雨時把門窗綑綁牢固。比喻事先做好準備工作。', 0, 0, ''),
(51, '臨渴掘井', 'ㄌㄧㄣˊ ㄎㄜˇ ㄐㄩㄝˊ ㄐㄧㄥˇ', '不早作準備，事到臨頭才想辦法。', 0, 0, ''),
(52, '按部就班', 'ㄢˋ ㄅㄨˋ ㄐㄧㄡˋ ㄅㄢ', '部，類別；班，次序。原指寫文章時選取適當義理，加以編排順序。後指做事按照部署，依次進行。也可指依照老規矩辦事。', 0, 0, ''),
(53, '指鹿為馬', 'ㄓˇ ㄌㄨˋ ㄨㄟˊ ㄇㄚˇ', '明明是鹿卻說是馬。比喻公然歪曲事實。', 0, 0, ''),
(54, '臨淵羨魚', 'ㄌㄧㄣˊ ㄩㄢ ㄒㄧㄢˋ ㄩˊ', '比喻只作空想，難收實效。（羨，希望得到。）', 0, 0, ''),
(55, '美輪美奐', 'ㄇㄟˇ ㄌㄨㄣˊ ㄇㄟˇ ㄏㄨㄢˋ', '輪：高大的樣子。奐：文彩鮮明的樣子。形容房屋規模高大、裝飾華美。', 0, 0, ''),
(56, '奔車朽索', 'ㄅㄣ ㄔㄜ ㄒㄧㄡˇ ㄙㄨㄛˇ', '用腐朽的繩子去駕馭正在狂奔的馬車。比喻所作所為極其危險。', 0, 0, ''),
(57, '虎尾春冰', 'ㄏㄨˇ ㄨㄟˇ ㄔㄨㄣ ㄅㄧㄥ', '踩著老虎的尾巴，踏在春天的薄冰上，均有生命之險。形容處境十分危險。', 0, 0, ''),
(58, '譁眾取寵', 'ㄏㄨㄚˊ ㄓㄨㄥˋ ㄑㄩˇ ㄔㄨㄥˇ', '指用浮誇的言行以取悅大眾。', 0, 0, ''),
(59, '張冠李戴', 'ㄓㄤ ㄍㄨㄢ ㄌㄧˇ ㄉㄞˋ', '弄錯了對象或弄錯了事實。', 0, 0, ''),
(60, '削足適履', 'ㄒㄩㄝˋ ㄗㄨˊ ㄕˋ ㄌㄩˇ', '削短腳趾來配合鞋子的大小。形容勉強求合，生搬硬套，而不顧及實際狀況。', 0, 0, ''),
(61, '前倨後恭', 'ㄑㄧㄢˊ ㄐㄩˋ ㄏㄡˋ ㄍㄨㄥ', '倨，傲慢；先前態度傲慢，後又轉為恭敬。用以譏笑勢利的人前後態度不一。', 0, 0, ''),
(62, '暴殄天物', 'ㄅㄠˋ ㄊㄧㄢˇ ㄊㄧㄢ ㄨˋ', '暴，損害、糟蹋；殄，滅絕；天物，指鳥獸草木等自然界生物。殘殺滅絕自然界的生物；後泛指對物品不知愛惜，任意糟蹋。', 0, 0, ''),
(63, '沽名釣譽', 'ㄍㄨ ㄇㄧㄥˊ ㄉㄧㄠˋ ㄩˋ', '指人矯情造作，用手段獵取名聲或讚譽。沽，買；釣，用餌引魚上鉤。', 0, 0, ''),
(64, '提綱挈領', 'ㄊㄧˊ ㄍㄤ ㄑㄧㄝˋ ㄌㄧㄥˇ', '綱，魚網上的總繩；挈，提起。全句是說「提起魚網的總繩，提起衣服的領子。」比喻抓住事理的重點。', 0, 0, ''),
(65, '緣木求魚', 'ㄩㄢˊ ㄇㄨˋ ㄑㄧㄡˊ ㄩˊ', '緣，動詞，順著東西往上爬。比喻方法、方向錯誤，根本不可能達到目的，徒勞無功而已。', 0, 0, ''),
(66, '南橘北枳', 'ㄋㄢˊ ㄐㄩˊ ㄅㄟˇ ㄓˇ', '比喻生長環境的好壞影響本質的優劣。（枳，似橘而小，果實味道不同；橘生長在淮南就叫做橘子，生長在淮北就是枳。）相關語詞：「逾淮為枳」、「橘化為枳」。', 0, 0, ''),
(67, '櫛風沐雨', 'ㄐㄧㄝˊ ㄈㄥ ㄇㄨˋ ㄩˇ', '櫛，梳理頭髮；沐，洗頭；以風梳髮，以雨洗頭；形容不避風雨，奔波勞頓。', 0, 0, ''),
(68, '甘之如飴', 'ㄍㄢ ㄓ ㄖㄨˊ ㄧˊ', '比喻樂於承擔艱苦的事情。（飴，糖）', 0, 0, ''),
(69, '亦步亦趨', 'ㄧˋ ㄅㄨˋ ㄧˋ ㄑㄩ', '步，慢步；趨，快走；原指學生緊隨老師。後來形容任何事情都模仿或追隨別人，完全沒有自己的主張。', 0, 0, ''),
(70, '甚囂塵上', 'ㄕㄣˋ ㄒㄧㄠ ㄔㄣˊ ㄕㄤˋ', '喧譁嘈雜，塵沙飛揚，原指軍隊作戰前的準備情況。後用「甚囂塵上」形容傳聞四起，議論紛紛；或指極為猖狂、囂張。', 0, 0, ''),
(71, '杯水車薪', 'ㄅㄟ ㄕㄨㄟˇ ㄐㄩ ㄒㄧㄣ', '用一杯水去救一車著火的柴草。比喻力量微小，無濟於事。', 0, 0, ''),
(72, '水到渠成', 'ㄕㄨㄟˇ ㄉㄠˋ ㄑㄩˊ ㄔㄥˊ', '水流到的地方，自然會形成溝渠。比喻事情條件齊全，自然成功，不必強求。「瓜熟蒂落」同義。', 0, 0, ''),
(73, '倒行逆施', 'ㄉㄠˋ ㄒㄧㄥˊ ㄋㄧˋ ㄕ', '比喻不按照情理行事。後用「倒行逆施」比喻胡作非為的罪惡行徑。', 0, 0, ''),
(74, '不忮不求', 'ㄅㄨˋ ㄓˋ ㄅㄨˋ ㄑㄧㄡˊ', '忮，嫉妒。指不嫉妒，不貪得。後來多用來形容淡泊無求，不做非分之事的處世態度。', 0, 0, ''),
(75, '一鼓作氣', 'ㄧ ㄍㄨˇ ㄗㄨㄛˋ ㄑㄧˋ', '意指作戰時擊第一通鼓，戰士們最能鼓足勇氣。後比喻做事時要趁著剛開始時的勇氣去做才容易成功。與「打鐵趁熱、一氣呵成」相似。', 0, 0, ''),
(76, '字字珠璣', 'ㄗˋ ㄗˋ ㄓㄨ ㄐㄧ', '珠璣，比喻優美的文章或詞句。形容句子或文章中遣詞用字非常優美。', 0, 0, ''),
(77, '披肝瀝膽', 'ㄆㄧ ㄍㄢ ㄌㄧˋ ㄉㄢˇ', '把肝膽都拿出來。比喻做人極為真誠坦白。（瀝，作「披露」、「表陳」解）', 0, 0, ''),
(78, '明哲保身', 'ㄇㄧㄥˊ ㄓㄜˊ ㄅㄠˇ ㄕㄣ', '形容人能迴避禍患，保全己身。（明，明於理；哲，察於事）', 0, 0, ''),
(79, '洞燭先機', 'ㄉㄨㄥˋ ㄓㄨˊ ㄒㄧㄢ ㄐㄧ', '表示能清楚地預見事情先兆。（洞，副詞，透徹地；燭，動詞，照見）意同「洞燭幽微」。', 0, 0, ''),
(80, '趨之若鶩', 'ㄑㄩ ㄓ ㄖㄨㄛˋ ㄨˋ', '趨附於他的人像成群的野鴨一樣，比喻眾人爭相追逐某項事物。多用於貶義。 （鶩，野鴨）', 0, 0, ''),
(81, '蜚短流長', 'ㄈㄟ ㄉㄨㄢˇ ㄌㄧㄡˊ ㄔㄤˊ', '蜚，通「飛」。指無中生有，造謠生事。', 0, 0, ''),
(82, '高山仰止', 'ㄍㄠ ㄕㄢ ㄧㄤˇ ㄓˇ', '高山，巍峨的高山，比喻道德高尚。句謂巍峨的高山可以仰望，形容崇高的德行，令人景仰。亦作「高山仰之」。', 0, 0, ''),
(83, '自怨自艾', 'ㄗˋ ㄩㄢˋ ㄗˋ ㄧˋ', '艾，割草，比喻改正；原指悔恨自己的錯誤，自己改正。現在多指自責悔嘆。', 0, 0, ''),
(84, '大快朵頤', 'ㄉㄚˋ ㄎㄨㄞˋ ㄉㄨㄛˇ ㄧˊ', '朵，動。頤，下巴。朵頤，指動著腮頰欲食的樣子。指飽食愉快的樣子。與「大飽口福」相似。', 0, 0, ''),
(85, '優柔寡斷', 'ㄧㄡ ㄖㄡˊ ㄍㄨㄚˇ ㄉㄨㄢˋ', '優柔，猶豫不決；寡斷，缺乏決斷力。形容做事猶豫不果決。', 0, 0, ''),
(86, '魚雁往返', 'ㄩˊ ㄧㄢˋ ㄨㄤˇ ㄈㄢˇ', '魚雁皆指書信。用來比喻書信往來。', 0, 0, ''),
(87, '頤指氣使', 'ㄧˊ ㄓˇ ㄑㄧˋ ㄕˇ', '頤，下巴；頤指，不說話而用臉部表情示意；氣使，用神情去指揮別人。形容對別人態度傲慢。', 0, 0, ''),
(88, '人一己百', 'ㄖㄣˊ ㄧ ㄐㄧˇ ㄅㄞˇ', '別人一學就會的事，自己就用百倍的努力做到。用以勉人力學，勤能補拙。', 0, 0, ''),
(89, '言簡意賅', 'ㄧㄢˊ ㄐㄧㄢˇ ㄧˋ ㄍㄞ', '賅，完備；形容說話或寫文章簡明扼要，但意義卻能包括無遺。與「言近旨遠」、「言淺意深」義近。', 0, 0, ''),
(90, '立竿見影', 'ㄌㄧˋ ㄍㄢ ㄐㄧㄢˋ ㄧㄥˇ', '比喻功效迅速。', 0, 0, ''),
(91, '罄竹難書', 'ㄑㄧㄥˋ ㄓㄨˊ ㄋㄢˊ ㄕㄨ', '罄，盡；竹，古代寫書的竹簡；形容罪惡極多，無法細數。', 0, 0, ''),
(92, '杞人憂天', 'ㄑㄧˇ ㄖㄣˊ ㄧㄡ ㄊㄧㄢ', '古時杞國有個人，成天擔心天會塌下來，因而寢食難安。後來用以比喻無謂的憂慮。與「杞天之憂、庸人自擾」相似。', 0, 0, ''),
(93, '馬齒徒長', 'ㄇㄚˇ ㄔˇ ㄊㄨˊ ㄓㄤˇ', '馬齒隨著年歲而增多，比喻年齡。徒長用以謙稱自己只是年齡增多，但學問沒有長進，事業無成。', 0, 0, ''),
(94, '麻中蓬直', 'ㄇㄚˊ ㄓㄨㄥ ㄆㄥˊ ㄓˊ', '飛蓬草生長在麻中，不用扶持也能直立生長。形容好的環境可以對人產生積極的影響。近似「近朱者赤」、「潛移默化」。', 0, 0, ''),
(95, '牛角掛書', 'ㄋㄧㄡˊ ㄐㄧㄠˇ ㄍㄨㄚˋ ㄕㄨ', '掛書於牛角，且行且讀。形容勤苦向學。', 0, 0, ''),
(96, '濫竽充數', 'ㄌㄢˋ ㄩˊ ㄔㄨㄥ ㄕㄨˋ', '竽，竹製的簧管樂器；比喻沒有真才實學的人，混在行家裡面充數。', 0, 0, ''),
(97, '從善如流', 'ㄘㄨㄥˊ ㄕㄢˋ ㄖㄨˊ ㄌㄧㄡˊ', '表示樂於接受別人正確的意見。與「從善如登」相反。', 0, 0, ''),
(98, '囫圇吞棗', 'ㄏㄨˊ ㄌㄨㄣˊ ㄊㄨㄣ ㄗㄠˇ', '囫圇，完整的；比喻理解事物或學習時，不細加領悟，只是籠統含糊地接受。', 0, 0, ''),
(99, '如坐春風', 'ㄖㄨˊ ㄗㄨㄛˋ ㄔㄨㄣ ㄈㄥ', '好像沐浴在春風之中，意同如沐春風。比喻受到良師的諄諄教導。', 0, 0, ''),
(100, '耳濡目染', 'ㄦˇ ㄖㄨˊ ㄇㄨˋ ㄖㄢˇ', '濡，沾染；耳朵常聽，眼睛常看。指無形中受到影響而被同化。', 0, 0, ''),
(101, '一傅眾咻', 'ㄧ ㄈㄨˋ ㄓㄨㄥˋ ㄒㄧㄡ', '傅，教；咻，喧鬧；一個人教，許多人在旁喧鬧擾亂。喻學習環境的重要。', 0, 0, ''),
(102, '笑容可掬', 'ㄒㄧㄠˋ ㄖㄨㄥˊ ㄎㄜˇ ㄐㄩˊ', '掬，用兩手捧取。形容笑容滿面的樣子。與「喜形於色、笑逐顏開」相似。', 0, 0, ''),
(103, '如雷貫耳', 'ㄖㄨˊ ㄌㄟˊ ㄍㄨㄢˋ ㄦˇ', '好像雷聲傳入耳朵那樣響亮。比喻人名氣很大，眾所共聞。', 0, 0, ''),
(104, '望洋興嘆', 'ㄨㄤˋ ㄧㄤˊ ㄒㄧㄥ ㄊㄢˋ', '比喻因能力不足而自嘆不如或感到無可奈何。與「無可奈何」義近。', 0, 0, ''),
(105, '望其項背', 'ㄨㄤˋ ㄑㄧˊ ㄒㄧㄤˋ ㄅㄟˋ', '項，頸的後部；形容趕得上。「難以望其項背」則形容遠遠落後，比不上別人。', 0, 0, ''),
(106, '唾手可得', 'ㄊㄨㄛˋ ㄕㄡˇ ㄎㄜˇ ㄉㄜˊ', '往手上吐唾沫，比喻極容易取得。', 0, 0, ''),
(107, '胼手胝足', 'ㄆㄧㄢˊ ㄕㄡˇ ㄓ ㄗㄨˊ', '胼、胝，厚繭。手掌腳底因勞動過度，皮膚久受摩擦而產生厚繭。形容極為辛勞。', 0, 0, ''),
(108, '倩人捉刀', 'ㄑㄧㄢˋ ㄖㄣˊ ㄓㄨㄛ ㄉㄠ', '倩，請；捉刀，意指拿筆代寫文章，因為古代以刀削竹簡，而把文字刻在竹簡上。比喻請人代作文章。', 0, 0, ''),
(109, '一鳴驚人', 'ㄧ ㄇㄧㄥˊ ㄐㄧㄥ ㄖㄣˊ', '比喻平時默默無聞，潛藏才華，一旦有機會施展時，果真令人驚訝、佩服。與「庸庸碌碌、沒沒（默默）無聞」相反。', 0, 0, ''),
(110, '暮鼓晨鐘', 'ㄇㄨˋ ㄍㄨˇ ㄔㄣˊ ㄓㄨㄥ', '佛寺中敲鐘擊鼓以報時。原表示日子一天一天過去了，今用以比喻使人覺悟的言論；亦作「晨鐘暮鼓」。意近「當頭棒喝」。', 0, 0, ''),
(111, '大放厥詞', 'ㄉㄚˋ ㄈㄤˋ ㄐㄩㄝˊ ㄘˊ', '指發表誇張的言詞。', 0, 0, ''),
(112, '邯鄲學步', 'ㄏㄢˊ ㄉㄢ ㄒㄩㄝˊ ㄅㄨˋ', '比喻學他人不成，反而失去本來的面目。（典故：壽陵少年學邯鄲人走路，他不但沒有學成，反而連自己原來的步法也忘了，結果只好爬著回去）', 0, 0, ''),
(113, '迴腸盪氣', 'ㄉㄤˋ ㄑㄧˋ ㄏㄨㄟˊ ㄔㄤˊ ', '形容文章或音樂感人至深，又作「盪氣迴腸」。', 0, 0, ''),
(114, '音容宛在', 'ㄧㄣ ㄖㄨㄥˊ ㄨㄢˇ ㄗㄞˋ', '人的聲音與容貌彷若在眼前，多用於對死者的弔唁之詞。', 0, 0, ''),
(115, '名落孫山', 'ㄇㄧㄥˊ ㄌㄨㄛˋ ㄙㄨㄣ ㄕㄢ', '指考試或選拔未被錄取。', 0, 0, ''),
(116, '老嫗能解', 'ㄌㄠˇ ㄩˋ ㄋㄥˊ ㄐㄧㄝˇ', '嫗，老婦人；形容詩文的淺顯易懂。', 0, 0, ''),
(117, '晨昏定省', 'ㄔㄣˊ ㄏㄨㄣ ㄉㄧㄥˋ ㄒㄧㄥˇ', '子女侍奉父母的日常儀節。', 0, 0, ''),
(118, '按圖索驥', 'ㄢˋ ㄊㄨˊ ㄙㄨㄛˇ ㄐㄧˋ', '索，尋找；（1）比喻做事拘泥成法，不知靈活變通（2）比喻循著線索去尋找事物。', 0, 0, ''),
(119, '拾人牙慧', 'ㄕˊ ㄖㄣˊ ㄧㄚˊ ㄏㄨㄟˋ', '抄襲別人的語言文字。', 0, 0, ''),
(120, '趨庭之教', 'ㄑㄩ ㄊㄧㄥˊ ㄓ ㄐㄧㄠ ', '原指孔鯉快步穿過庭院時，孔子教兒子孔鯉學詩學禮的故事。今形容「父親對子女的教導」。', 0, 0, ''),
(121, '春風化雨', 'ㄔㄨㄣ ㄈㄥ ㄏㄨㄚˋ ㄩˇ', '老師的教導，如和暖  的春風吹拂，如及時的雨水潤化萬物。比喻完善的教化，使人潛移默化。', 0, 0, ''),
(122, '不落窠臼', 'ㄅㄨˋ ㄌㄨㄛˋ ㄎㄜ ㄐㄧㄡˋ', '比喻不落俗套，有獨創風格。', 0, 0, ''),
(123, '拋磚引玉', 'ㄆㄠ ㄓㄨㄢ ㄧㄣˇ ㄩˋ', '比喻先以自己粗陋的見解或行動來引發別人美好的言論或行為。謙稱自己率先做事。', 0, 0, ''),
(124, '渾渾噩噩', 'ㄏㄨㄣˊ ㄏㄨㄣˊ ㄜˋ ㄜˋ', '渾渾，渾厚的樣子；噩噩，嚴正的樣子；句謂人渾樸天真，嚴肅敦厚。今用以形容人糊里糊塗，或對事物無所用心的樣子。', 0, 0, ''),
(125, '迎刃而解', 'ㄧㄥˊ ㄖㄣˋ ㄦˊ ㄐㄧㄝˇ', '迎著刀刃的竹子，會順著刀勢裂開。形容相連的事物很容易分解，亦用來比喻事情很容易處理。', 0, 0, ''),
(126, '鳳毛麟角', 'ㄈㄥˋ ㄇㄠˊ ㄌㄧㄣˊ ㄐㄧㄠˇ （又音）ㄈㄥˋ ㄇㄠˊ ㄌㄧㄣˊ ㄐㄩㄝˊ', '鳳凰的羽毛、麒麟的角。比喻稀罕珍貴的人、物。與「吉光片羽」、「屈指可數」、「寥若晨星」義近。', 0, 0, ''),
(127, '鞭辟入裡', 'ㄅㄧㄢ ㄅㄧˋ ㄖㄨˋ ㄌㄧˇ', '鞭，鞭策；辟，透徹。鞭策剖析到最深層，指做學問自我督策，深入精微研究。後多以之形容言辭或文章說理深刻、透徹。', 0, 0, ''),
(128, '擲地有聲', 'ㄓˊ ㄉㄧˋ ㄧㄡˇ ㄕㄥ', '形容文辭巧妙華美、說話音韻鏗鏘一有致。', 0, 0, ''),
(129, '疊床架屋', 'ㄉㄧㄝˊ ㄔㄨㄤˊ ㄐㄧㄚˋ ㄨ', '比喻一切措施，如說話、作文、設施制度等，重複其事，全無創建發明。「屋下架屋」、「床上施床」亦同。', 0, 0, ''),
(130, '信口雌黃', 'ㄒㄧㄣˋ ㄎㄡˇ ㄘ ㄏㄨㄤˊ', '雌黃，橙黃色礦物，古代用於塗改文字。本指有如口中含著雌黃，能隨時改正不合意的語句。後用「信口雌黃」比喻不顧事實真相，隨口亂說或妄加批評。', 0, 0, ''),
(131, '欲蓋彌彰', 'ㄩˋ ㄍㄞˋ ㄇㄧˊ ㄓㄤ', '形容想要掩飾過失，反而使過失更加明顯。', 0, 0, ''),
(132, '絃歌不輟', 'ㄒㄧㄢˊ ㄍㄜ ㄅㄨˊ ㄔㄨㄛˋ ', '絃歌，本指用絃樂器伴奏而吟詠，泛指讀書、教學活動或禮樂教化。輟，停止。句謂讀書的聲音不停；比喻（1）講習、教學活動沒有間斷（2）學風很盛。', 0, 0, ''),
(133, '不脛而走', 'ㄅㄨˋ ㄐㄧㄥˋ ㄦˊ ㄗㄡˇ', '脛，小腿。「不脛而走」指沒有腿也能去。比喻事物不用推廣，也能迅速傳播。', 0, 0, ''),
(134, '黔驢技窮', 'ㄑㄧㄢˊ ㄌㄩˊ ㄐㄧˋ ㄑㄩㄥˊ', '比喻人拙劣的技能已經使完，而終至露出無能的本質。', 0, 0, ''),
(135, '生靈塗炭', 'ㄕㄥ ㄌㄧㄥˊ ㄊㄨˊ ㄊㄢˋ', '生靈，百姓；塗，泥濘；炭，炭火。塗炭指像陷入水深火熱之中，處境痛苦。形容老百姓的處境極為艱難痛苦。', 0, 0, ''),
(136, '風行草偃', 'ㄈㄥ ㄒㄧㄥˊ ㄘㄠˇ ㄧㄢˇ', '行，移動；偃，倒伏；風一吹過，草就倒伏。形容執政者以德化民，收效快速。', 0, 0, ''),
(137, '沐猴而冠', 'ㄇㄨˋ ㄏㄡˊ ㄦˊ ㄍㄨㄢ', '沐猴，獼猴。「沐猴而冠」指性情急躁的獼猴學人穿戴冠帽。比喻人虛有表象，卻不脫粗鄙的本質。', 0, 0, ''),
(138, '摩頂放踵', 'ㄇㄛˊ ㄉㄧㄥˇ ㄈㄤˇ ㄓㄨㄥˇ', '摩，磨損；放，至；踵，腳跟。句意：從頭到腳都磨破皮。形容一個人具有熱心救世的熱誠，為了眾人奔波勞苦。', 0, 0, ''),
(139, '模稜兩可', 'ㄇㄛˊ ㄌㄥˊ ㄌㄧㄤˇ ㄎㄜˇ', '摸物稜角兩端，摸那一端都可以。比喻處理事情的態度含混，不表示明確的意見或主張。。', 0, 0, ''),
(140, '芒刺在背', 'ㄇㄤˊ ㄘˋ ㄗㄞˋ ㄅㄟˋ', '像是有許多細小的芒刺沾在背上，令人坐立難安。比喻因畏忌而極度不安。與「如坐針氈」義近。', 0, 0, ''),
(141, '三人成虎', 'ㄙㄢ ㄖㄣˊ ㄔㄥˊ ㄏㄨˇ', '比喻謠言或不實的傳聞經過多人散播，就會使人信以為真。', 0, 0, ''),
(142, '指桑罵槐', 'ㄓˇ ㄙㄤ ㄇㄚˋ ㄏㄨㄞˊ', '指著桑樹罵槐樹，比喻拐彎抹角的罵人。', 0, 0, ''),
(143, '舐犢情深', 'ㄕˋ ㄉㄨˊ ㄑㄧㄥˊ ㄕㄣ', '舐，舔；犢，小牛；比喻父母疼愛子女的深情。', 0, 0, ''),
(144, '慎終追遠', 'ㄕㄣˋ ㄓㄨㄥ ㄓㄨㄟ ㄩㄢˇ', '謹慎處理父母的喪事，虔誠的追念祖先。指人不忘本，是重視孝道的用語。', 0, 0, ''),
(145, '韜光養晦', 'ㄊㄠ ㄍㄨㄤ ㄧㄤˇ ㄏㄨㄟˋ', '韜，隱藏；晦，昏暗。比喻把聲名或才華隱藏起來不外露。', 0, 0, ''),
(146, '毛遂自薦', 'ㄇㄠˊ ㄙㄨㄟˋ ㄗˋ ㄐㄧㄢˋ', '毛遂，戰國趙人，為平原君食客。比喻自我推薦。', 0, 0, ''),
(147, '斷章取義', 'ㄉㄨㄢˋ ㄓㄤ ㄑㄩˇ ㄧˋ', '原意是取詩經的某一章來表達自己的心意。後來指：引用別人的文章或談話的片斷，而不顧及全篇內容與意思。', 0, 0, ''),
(148, '戰戰兢兢', 'ㄓㄢˋ ㄓㄢˋ ㄐㄧㄥ ㄐㄧㄥ', '戰戰，害怕的樣子；兢兢，小心謹慎的樣子。形容做事時戒慎惶恐的態度。與「兢兢業業」（註：業業，警惕小心的樣子 ）類似。', 0, 0, ''),
(149, '望塵莫及', 'ㄨㄤˋ ㄔㄣˊ ㄇㄛˋ ㄐㄧˊ', '及，達到；只見塵土飛揚而無法再趕上，指遠遠落於人後。', 0, 0, ''),
(150, '並駕齊驅', 'ㄅㄧㄥˋ ㄐㄧㄚˋ ㄑㄧˊ ㄑㄩ', '本指車駕並行，馬匹並排一齊奔跑。比喻彼此能力或地位，彼此相等。', 0, 0, ''),
(151, '東施效顰', 'ㄉㄨㄥ ㄕ ㄒㄧㄠˋ ㄆㄧㄣˊ', '效，仿效；顰，皺眉。比喻不知別人長處何在，胡亂模仿，結果適得其反。「邯鄲學步」、「畫虎類犬」義同。', 0, 0, ''),
(152, '刮目相看', 'ㄍㄨㄚ ㄇㄨˋ ㄒㄧㄤ ㄎㄢˋ', '又作「另眼相看」、「另眼相待」。指對方已不同往日或較別人特殊而給予與眾不同的對待。', 0, 0, ''),
(153, '退避三舍', 'ㄊㄨㄟˋ ㄅㄧˋ ㄙㄢ ㄕㄜˋ', '本指作戰時，退兵九十里以表退讓，後引申為對別人忍讓，不敢相爭的意思。（三舍，古時行軍三十里為一舍，三舍為九十里）', 0, 0, ''),
(154, '剛愎自用', 'ㄍㄤ ㄅㄧˋ ㄗˋ ㄩㄥˋ', '愎，固執己見；自用，自以為是。固執己見，專斷獨行。意同「師心自用」、「一意孤行」、「獨斷專行」。', 0, 0, ''),
(155, '咎由自取', 'ㄐㄧㄡˋ ㄧㄡˊ ㄗˋ ㄑㄩˇ', '咎，罪過；罪過、災禍是自己招來的。', 0, 0, ''),
(156, '無遠弗屆', 'ㄨˊ ㄩㄢˇ ㄈㄨˊ ㄐㄧㄝˋ', '屆，到的意思；指沒有不能到達的地方。', 0, 0, ''),
(157, '千鈞一髮', 'ㄑㄧㄢ ㄐㄩㄣ ㄧ ㄈㄚˇ', '以一根頭髮懸吊千鈞重物，比喻情況非常危急。（鈞，古代重量單位，三十斤）', 0, 0, ''),
(158, '破鏡重圓', 'ㄆㄛˋ ㄐㄧㄥˋ ㄔㄨㄥˊ ㄩㄢˊ', '比喻「夫妻」離散後又再復合。', 0, 0, ''),
(159, '破釜沉舟', 'ㄆㄛˋ ㄈㄨˇ ㄔㄣˊ ㄓㄡ', '釜，鍋；比喻下定決心 ，只以一次機會就達到成功的目標，絕不留後路。', 0, 0, ''),
(160, '韋編三絕', 'ㄨㄟˊ ㄅㄧㄢ ㄙㄢ ㄐㄩㄝˊ', '韋，熟牛皮，古時用竹簡寫字，竹簡用牛皮帶編聯起來；三絕，指多次斷絕。用以形容讀書刻苦勤奮。', 0, 0, ''),
(161, '信誓旦旦', 'ㄒㄧㄣˋ ㄕˋ ㄉㄢˋ ㄉㄢˋ', '旦旦，誠懇的樣子，指誓言說得極為誠懇可信。', 0, 0, ''),
(162, '撥雲見日', 'ㄅㄛ ㄩㄣˊ ㄐㄧㄢˋ ㄖˋ', '比喻事態轉為明朗或形容境遇由壞轉好。意同「否極泰來」、「時來運轉」。', 0, 0, ''),
(163, '中流砥柱', 'ㄓㄨㄥ ㄌㄧㄡˊ ㄉㄧˇ ㄓㄨˋ', '中流，指黃河中游；砥柱，屹立於黃河中游之山。形容人在艱難動盪的環境中能擔當大任。', 0, 0, ''),
(164, '車水馬龍', 'ㄔㄜ ㄕㄨㄟˇ ㄇㄚˇ ㄌㄨㄥˊ', '車像流水，馬像長龍一樣往來不絕。形容車馬往來不絕的繁華熱鬧。與「川流不息」、「熙來攘往」、「絡繹不絕」義近。（川流不息：像河裡的水流一樣連續不斷，比喻來往行人、車馬很多。）', 0, 0, ''),
(165, '維妙維肖', 'ㄨㄟˊ ㄇㄧㄠˋ ㄨㄟˊ ㄒㄧㄠˋ', '維，文言語助詞；妙，美、好；肖，像、逼真。形容描寫或模仿極為逼真。', 0, 0, ''),
(166, '滄海桑田', 'ㄘㄤ ㄏㄞˇ ㄙㄤ ㄊㄧㄢˊ', '大海變為桑田，桑田變為滄海。比喻世事變化很大。也作「滄海揚塵」、「東海揚塵」（註：海面揚塵，已經變為陸地的景象）', 0, 0, ''),
(167, '滄海一粟', 'ㄘㄤ ㄏㄞˇ ㄧ ㄙㄨˋ', '粟，小米；比喻人在天地間，如大海中的一粒小米粒，極其渺小。※比較「曇花（華）一現」：曇花開放幾個小時就凋謝了，形容事物出現不久就消逝，極為短暫。', 0, 0, ''),
(168, '年高德劭', 'ㄋㄧㄢˊ ㄍㄠ ㄉㄜˊ ㄕㄠˋ', '劭，美好。形容人年紀大而德行優美，受人尊敬。「德高望重」、「齒德俱尊」（註：齒，指年齡）義近。', 0, 0, ''),
(169, '管鮑之交', 'ㄍㄨㄢˇ ㄅㄠˋ ㄓ ㄐㄧㄠ', '春秋齊國管仲和鮑叔牙相知最深。比喻交情深厚。', 0, 0, ''),
(170, '既往不咎', 'ㄐㄧˋ ㄨㄤˇ ㄅㄨˋ ㄐㄧㄡˋ', '既，已經；咎，怪罪。形容對已經過去的錯事，不再追究責備。', 0, 0, ''),
(171, '繼往開來', 'ㄐㄧˋ ㄨㄤˇ ㄎㄞ ㄌㄞˊ', '指承繼先人的成就，開拓未來的新局面。北宋張載西銘：「為往聖繼絕學，為萬世開太平。」→譯：為古聖先賢承繼中斷的學術，為萬代子孫開創永久的太平聖世。', 0, 0, ''),
(172, '相形見絀', 'ㄒㄧㄤ ㄒㄧㄥˊ ㄐㄧㄢˋ ㄔㄨˋ', '相形，比較；絀，不足。表示兩相比較，顯出其中一方的拙劣。也用作謙詞。', 0, 0, ''),
(173, '人謀不臧', 'ㄖㄣˊ ㄇㄡˊ ㄅㄨˋ ㄗㄤ', '謀，謀畫；臧，善、好；句謂人的謀畫不妥善。常用以說明事情失敗的原因，是人為所導致，與天命毫無關係。', 0, 0, ''),
(174, '叱吒風雲', 'ㄔˋ ㄓㄚˋ ㄈㄥ ㄩㄣˊ', '叱吒，怒喝。一聲怒喝就能使風雲變色。形容人聲勢威力極大，能左右世局。', 0, 0, ''),
(175, '物換星移', 'ㄨˋ ㄏㄨㄢˋ ㄒㄧㄥ ㄧˊ', '景物變換，星辰位置移動；形容時序的變遷，人事的變化。', 0, 0, ''),
(176, '二八年華', 'ㄦˋ ㄅㄚ ㄋㄧㄢˊ ㄏㄨㄚˊ', '二八，即十六歲。用以形容少女正當青春美麗的時期。', 0, 0, ''),
(177, '明日黃花', 'ㄇㄧㄥˊ ㄖˋ ㄏㄨㄤˊ ㄏㄨㄚ', '原指時移事易，好景不常；今多比喻「過時的事物」失去了原來的意義。', 0, 0, ''),
(178, '膾炙人口', 'ㄎㄨㄞˋ ㄓˋ ㄖㄣˊ ㄎㄡˇ', '膾，切細的肉；炙，烤肉；二者是人人喜愛的美味。句指詩文或事物被眾人所喜愛而流傳。', 0, 0, ''),
(179, '道貌岸然', 'ㄉㄠˋ ㄇㄠˋ ㄢˋ ㄖㄢˊ', '神態莊嚴，一副道學家的樣子，與「嬉皮笑臉」相反；常含有譏諷的意味，指一個人表面上故作嚴肅，事實上表裡不一。（岸然，高傲威嚴的樣子）', 0, 0, ''),
(180, '夜不閉戶', 'ㄧㄝˋ ㄅㄨˋ ㄅㄧˋ ㄏㄨˋ', '夜間睡覺不用關門，形容社會秩序良好安定，盜賊絕跡。同「路不拾遺」。', 0, 0, ''),
(181, '梨園子弟', 'ㄌㄧˊ ㄩㄢˊ ㄗˇ ㄉㄧˋ', '梨園，原指唐玄宗教練歌舞藝人的地方。 後泛稱戲班為梨園；戲劇演員為「梨園子弟」或「梨園弟子」。', 0, 0, ''),
(182, '匹夫之勇', 'ㄆㄧˇ ㄈㄨ ㄓ ㄩㄥˇ', '匹夫，一個人，泛指普通  人；形容沒有智謀，僅憑個人蠻幹的勇敢。', 0, 0, ''),
(183, '嘔心瀝血', 'ㄡˇ ㄒㄧㄣ ㄌㄧˋ ㄒㄩㄝˋ', '瀝，滴下。形容用盡心思腦力。', 0, 0, ''),
(184, '草菅人命', 'ㄘㄠˇ ㄐㄧㄢ ㄖㄣˊ ㄇㄧㄥˋ', '菅，一種野草；句謂把人命看做野草。指為政者漠視人命，任意殘害。', 0, 0, ''),
(185, '同舟共濟', 'ㄊㄨㄥˊ ㄓㄡ ㄍㄨㄥˋ ㄐㄧˋ', '濟，渡河。大家同坐一條船渡河，比喻利害一致、患難與共。與「風雨同舟」、「和衷共濟」、「同心協力」義近。', 0, 0, ''),
(186, '瞠目結舌', 'ㄔㄥ ㄇㄨˋ ㄐㄧㄝˊ ㄕㄜˊ', '瞪大眼睛看而說不出話來，形容受窘或驚呆的樣子。', 0, 0, ''),
(187, '動如參商', 'ㄉㄨㄥˋ ㄖㄨˊ ㄕㄣ ㄕㄤ', '參、商，均為二十八星宿名；參星出現在西方，商星出現在東方，兩者不能在空中同時出現。比喻分離後難以會面。', 0, 0, ''),
(188, '杯弓蛇影', 'ㄅㄟ ㄍㄨㄥ ㄕㄜˊ ㄧㄥˇ', '酒杯中映出弓的影子，像是有一條蛇。比喻因無中生有的疑慮自相驚擾不已。「草木皆兵」（註：把山上的草木都當作敵兵，形容極度驚恐時，疑神疑鬼的心理）義近。', 0, 0, ''),
(189, '錙銖必較', 'ㄗ ㄓㄨ ㄅㄧˋ ㄐㄧㄠˋ', '錙銖，古代重量單位；六銖為一錙，四錙為一兩；指極小的份量。用以形容對細微的事物或很少的錢財都要計較。同「斤斤計較」。', 0, 0, ''),
(190, '談笑風生', 'ㄊㄢˊ ㄒㄧㄠˋ ㄈㄥ ㄕㄥ', '風生，風趣四溢；句謂談話時有說有笑，興致極高而風趣。', 0, 0, ''),
(191, '妄自菲薄', 'ㄨㄤˋ ㄗˋ ㄈㄟˇ ㄅㄛˊ', '妄，沒根據、不實際，或做任意、輕率解。菲薄，動詞，輕視；句謂輕率地鄙視自己，形容人自輕自賤，過份地小看自己。', 0, 0, ''),
(192, '古道熱腸', 'ㄍㄨˇ ㄉㄠˋ ㄖㄜˋ ㄔㄤˊ', '古道，指古代敦厚純樸的道德風尚，不似今人薄情貪利。熱腸，熱心腸。形容待人厚道，真摯熱情；讚美有救助別人的美德。', 0, 0, ''),
(193, '病入膏肓', 'ㄅㄧㄥˋ ㄖㄨˋ ㄍㄠ ㄏㄨㄤ', '古代醫家指心尖脂肪為膏，心臟和隔膜之間為肓，認為膏肓之間為藥力所不能達到之處。句指病重到了無法醫治的地步；也比喻事態嚴重到無法挽回的程度。同「藥石無功」、「無可救藥」、「沈痾難起」（痾，病）。', 0, 0, ''),
(194, '野人獻曝', 'ㄧㄝˇ ㄖㄣˊ ㄒㄧㄢˋ ㄆㄨˋ', '野人，鄉野鄙夫，一般指農夫；曝，曬太陽。指平凡人所能貢獻的平凡事物，常用作提出建議時的自謙之詞，比喻所見雖然淺陋，而貢獻出於真心。', 0, 0, ''),
(195, '天馬行空', 'ㄊㄧㄢ ㄇㄚˇ ㄒㄧㄥˊ ㄎㄨㄥ', '天馬，神馬。行空，在天空奔馳。比喻（1）才思橫溢，氣勢豪放（2）不切實際的思想。', 0, 0, ''),
(196, '螳臂當車', 'ㄊㄤˊ ㄅㄧˋ ㄉㄤ ㄔㄜ', '當，同「擋」，阻擋；螳螂用前肢去阻擋車輪前進。比喻氣雄力薄，根本無濟於事；譏諷人不自量力。與「蚍蜉撼樹」、「以卵擊石」義近。', 0, 0, ''),
(197, '義憤填膺', 'ㄧˋ ㄈㄣˋ ㄊㄧㄢˊ ㄧㄥ', '膺，胸膛； 表示一個人為正義之不伸而激起的憤慨，充滿胸中。', 0, 0, ''),
(198, '進退維谷', 'ㄐㄧㄣˋ ㄊㄨㄟˋ ㄨㄟˊ ㄍㄨˇ', '形容前進後退都無路可走的困窘處境。意同「進退兩難」', 0, 0, ''),
(199, '買櫝還珠', 'ㄇㄞˇ ㄉㄨˊ ㄏㄨㄢˊ ㄓㄨ', '買了裝珍珠的盒子，而把珍珠退還。後用「買櫝還珠」比喻捨本逐末，取捨失當。', 0, 0, ''),
(200, '門可羅雀', 'ㄇㄣˊ ㄎㄜˇ ㄌㄨㄛˊ ㄑㄩㄝˋ', '門前冷清，空曠得可張網捕雀。形容做官的人失勢後賓客稀少的景況。', 0, 0, '');
