<?php

if (isset($_GET['dir'])) {
    //设置文件目录
    $basedir = $_GET['dir'];
} else {
    $basedir = '.';
}

checkdir($basedir);

/**
 * 遍历目录
 * @param string $basedir 基础目录
 */
function checkdir($basedir)
{
    if ($dh = opendir($basedir)) {
        while (($file = readdir($dh)) !== false) {
            if ($file != '.' && $file != '..') {
                if (!is_dir($basedir . "/" . $file)) {
                    echo "filename: $basedir/$file " . checkBOM("$basedir/$file") . " <br>";
                } else {
                    $dirname = $basedir . "/" . $file;
                    checkdir($dirname);
                }
            }
        }
        closedir($dh);
    }
}

/**
 * 检查BOM头
 * @param string $filename 文件名
 * @param int $auto 是否自动处理，默认自动处理
 */
function checkBOM($filename, $auto = 1)
{
    $contents   = file_get_contents($filename);
    $charset[1] = substr($contents, 0, 1);
    $charset[2] = substr($contents, 1, 1);
    $charset[3] = substr($contents, 2, 1);
    if (ord($charset[1]) == 239 && ord($charset[2]) == 187 && ord($charset[3]) == 191) {
        if ($auto == 1) {
            $rest = substr($contents, 3);
            rewrite($filename, $rest);
            return ("<font color=red>BOM found, automatically removed.  <a href=http://www.cnblogs.com/lfire/archive/2012/11/20/2778939.html>lfire博客</a></font>");
        } else {
            return ("<font color=red>BOM found.</font>");
        }
    } else {
        return ("BOM Not Found.");
    }

}

/**
 * 重写文件
 * @param string $filename 需要重写的文件
 * @param mixed $data 要重写的数据
 */
function rewrite($filename, $data)
{
    $filenum = fopen($filename, "w");
    flock($filenum, LOCK_EX);
    fwrite($filenum, $data);
    fclose($filenum);
}
