CREATE TABLE `tad_news` (
  `nsn` smallint(5) unsigned NOT NULL auto_increment,
  `ncsn` smallint(5) unsigned NOT NULL,
  `news_title` varchar(255) NOT NULL default '',
  `news_content` text NOT NULL,
  `start_day` datetime NOT NULL default '0000-00-00 00:00:00',
  `end_day` datetime default NULL,
  `enable` enum('1','0') NOT NULL default '1',
  `uid` smallint(5) unsigned NOT NULL,
  `passwd` varchar(255) NOT NULL default '',
  `enable_group` varchar(255) NOT NULL default '',
  `counter` smallint(6) unsigned NOT NULL,
  `prefix_tag` VARCHAR( 255 ) NOT NULL default '',
	`always_top` ENUM( '0', '1' ) NOT NULL default '0',
  PRIMARY KEY  (`nsn`)
);



CREATE TABLE `tad_news_cate` (
  `ncsn` smallint(5) unsigned NOT NULL auto_increment,
  `of_ncsn` smallint(5) unsigned NOT NULL,
  `nc_title` varchar(255) NOT NULL default '',
  `enable_group` varchar(255) NOT NULL default '',
  `enable_post_group` varchar(255) NOT NULL default '',
  `sort` smallint(5) unsigned NOT NULL,
  PRIMARY KEY  (`ncsn`)
);


CREATE TABLE `tad_news_files` (
`fsn` SMALLINT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY ,
`nsn` SMALLINT UNSIGNED NOT NULL ,
`file_name` VARCHAR( 255 ) NOT NULL ,
`file_size` VARCHAR( 255 ) NOT NULL ,
`file_type` VARCHAR( 255 ) NOT NULL ,
`counter` SMALLINT UNSIGNED NOT NULL,
INDEX ( `nsn` )
);

CREATE TABLE `tad_news_paper` (
`npsn` SMALLINT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY ,
`nps_sn` MEDIUMINT UNSIGNED NOT NULL ,
`number` SMALLINT UNSIGNED NOT NULL ,
`nsn_array` TEXT NOT NULL ,
`np_content` TEXT NOT NULL ,
`np_date` DATETIME NOT NULL
);

CREATE TABLE `tad_news_paper_setup` (
`nps_sn` MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY ,
`title` VARCHAR( 255 ) NOT NULL ,
`head` TEXT NOT NULL ,
`foot` TEXT NOT NULL ,
`themes` VARCHAR( 255 ) NOT NULL,
`status` ENUM( '1', '0' ) NOT NULL
);

CREATE TABLE `tad_news_paper_email` (
  `nps_sn` smallint(6) NOT NULL,
  `email` varchar(255) NOT NULL,
  `order_date` datetime NOT NULL,
  PRIMARY KEY  (`nps_sn`,`email`)
) TYPE=MyISAM;