<?php
/**
 * @license    tnjaile
 * @author     tnjaile
 * @version    1.0
 * 工具類，封裝函数和算法等。
 * 直接取用
 * Tool::getIP();
 **/

class Tool
{

    //取得客户端ip get client IP
    public static function getIP()
    {
        return $_SERVER["REMOTE_ADDR"];
    }

    //取得目前的時間 get current time
    public static function getDate()
    {
        //date_default_timezone_set('Asia/Taipei');
        return date('Y-m-d H:i:s');
    }

    //避免表單輸入特殊字符:a\dm<?"in Avoid form input special characters: a\dm<?"in
    public static function setFormString($_string, $_filter_typ = "")
    {
        if (Validate::isArray($_string)) {
            foreach ($_string as $_key => $_value) {
                $_string[$_key] = self::setFormString($_value, $_filter_typ);
            }
        } else {
            switch ($_filter_typ) {
                case 'date':
                    $_string = strtotime($_string);
                    break;
                case 'string':
                    $_string = filter_var($_string, FILTER_SANITIZE_SPECIAL_CHARS);
                    break;
                case 'int':
                    $_string = (int) $_string;
                    break;
                default:
                    $_string = addslashes($_string);
                    break;
            }
        }
        return $_string;
    }

    //表單下拉選單轉換 Form drop-down menu conversion
    public static function setFormItem($_data, $_key, $_value)
    {
        $_items = array();

        if (Validate::isArray($_data)) {

            foreach ($_data as $_v) {
                $_items[$_v->$_key] = $_v->$_value;
            }
        }
        return $_items;
    }

    //html過濾 HTML Filtering
    public static function setHtmlString($_data)
    {
        if (is_array($_data)) {
            foreach ($_data as $_key => $_value) {
                $_string[$_key] = self::setHtmlString($_value); //遞迴
            }
        } elseif (is_object($_data)) {
            $_string = new stdClass();
            foreach ($_data as $_key => $_value) {
                $_string->$_key = self::setHtmlString($_value); //遞迴
            }
            //die(var_dump($_string));
        } else {
            $_string = htmlspecialchars($_data);
        }
        return $_string;
    }

    //過濾  filter
    public static function setRequest()
    {
        //用filter_var比較好//It is better to use filter var
        if (isset($_GET)) {
            $_GET = Tool::setFormString($_GET, $_param);
        }
    }
    //將偏好設定作成選單 Make preferences a menu
    public static function module_config_menu($name = "", $default = "", $syb = ";")
    {
        global $xoopsModuleConfig;
        $arr = explode($syb, $xoopsModuleConfig[$name]);
        $opt = array();
        foreach ($arr as $value) {
            if (preg_match("/=/", $value)) {
                $value_arr          = explode("=", $value);
                $opt[$value_arr[0]] = $value_arr[1];
            } else {
                $opt[$value] = $value;
            }
        }
        return $opt;
    }

}
