CREATE TABLE `tadnews_files_center` (
  `files_sn` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `col_name` varchar(255) NOT NULL,
  `col_sn` smallint(5) unsigned NOT NULL,
  `sort` smallint(5) unsigned NOT NULL,
  `kind` enum('img','file') NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `file_type` varchar(255) NOT NULL,
  `file_size` int(10) unsigned NOT NULL,
  `description` text NOT NULL,
  `counter` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`files_sn`)
) TYPE=MyISAM ;



CREATE TABLE `tad_news` (
  `nsn` smallint(5) unsigned NOT NULL auto_increment,
  `ncsn` smallint(5) unsigned NOT NULL,
  `news_title` varchar(255) NOT NULL default '',
  `news_content` text NOT NULL,
  `start_day` datetime NOT NULL default '0000-00-00 00:00:00',
  `end_day` datetime default NULL,
  `enable` enum('1','0') NOT NULL default '1',
  `uid` smallint(5) unsigned NOT NULL,
  `passwd` varchar(255) NOT NULL default '',
  `enable_group` varchar(255) NOT NULL default '',
  `counter` smallint(5) unsigned NOT NULL,
  `prefix_tag` varchar(255) NOT NULL,
  `always_top` enum('0','1') NOT NULL,
  `always_top_date` datetime NOT NULL default '0000-00-00 00:00:00',
  PRIMARY KEY  (`nsn`)
) ;



CREATE TABLE `tad_news_cate` (
  `ncsn` smallint(5) unsigned NOT NULL auto_increment,
  `of_ncsn` smallint(5) unsigned NOT NULL,
  `nc_title` varchar(255) NOT NULL default '',
  `enable_group` varchar(255) NOT NULL default '',
  `enable_post_group` varchar(255) NOT NULL,
  `sort` smallint(5) unsigned NOT NULL,
  `cate_pic` varchar(255) NOT NULL,
  `not_news` enum('0','1') NOT NULL,
  `setup` TEXT NOT NULL,
  PRIMARY KEY  (`ncsn`)
) ;



CREATE TABLE `tad_news_paper` (
  `npsn` smallint(5) unsigned NOT NULL auto_increment,
  `nps_sn` mediumint(8) unsigned NOT NULL,
  `number` smallint(5) unsigned NOT NULL,
  `nsn_array` text NOT NULL,
  `np_content` text NOT NULL,
  `np_date` datetime NOT NULL,
  PRIMARY KEY  (`npsn`)
) ;


CREATE TABLE `tad_news_paper_email` (
  `nps_sn` smallint(6) NOT NULL,
  `email` varchar(255) NOT NULL,
  `order_date` datetime NOT NULL,
  PRIMARY KEY  (`nps_sn`,`email`)
);



CREATE TABLE `tad_news_paper_setup` (
  `nps_sn` mediumint(8) unsigned NOT NULL auto_increment,
  `title` varchar(255) NOT NULL,
  `head` text NOT NULL,
  `foot` text NOT NULL,
  `themes` varchar(255) NOT NULL,
  `status` enum('1','0') NOT NULL,
  PRIMARY KEY  (`nps_sn`)
) ;
