"use strict"
/**
 * @class  elFinder command "sort"
 * Change sort files rule
 *
 * @author Dmitry (dio) Levashov
 **/
elFinder.prototype.commands.sort = function() {
	/**
	 * Command options
	 *
	 * @type  Object
	 */
	this.options = {ui : 'sortbutton'};
	
	this.getstate = function() {
		return 0;
	}
	
	this.exec = function(hashes, sort) {
		var fm = this.fm,
			sort = $.extend({
				type  : fm.sortType,
				order : fm.sortOrder,
				stick : fm.sortStickFolders
			}, sort);

		this.fm.setSort(sort.type, sort.order, sort.stick);
		return $.Deferred().resolve();
	}

}