<?php
/**
 * XOOPS feed creator
 *
 * You may not change or alter any portion of this comment or credits
 * of supporting developers from this source code or any supporting source code
 * which is considered copyrighted (c) material of the original comment or credit authors.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * @copyright       The XOOPS Project http://sourceforge.net/projects/xoops/
 * @license         GNU GPL 2 (http://www.gnu.org/licenses/old-licenses/gpl-2.0.html)
 * @since           2.0.0
 * @version         $Id: backend.php 4941 2010-07-22 17:13:36Z beckmi $
 */
 
include dirname(__FILE__) . DIRECTORY_SEPARATOR . 'mainfile.php';

$GLOBALS['xoopsLogger']->activated = false;
if (function_exists('mb_http_output')) {
    mb_http_output('pass');
}
header('Content-Type:text/xml; charset=utf-8');

include_once $GLOBALS['xoops']->path('class/template.php');
$today=date("Y-m-d H:i:s");
$tpl = new XoopsTpl();
$tpl->xoops_setCaching(2);
$tpl->xoops_setCacheTime(3600);
if (!$tpl->is_cached('db:system_rss.html')) {
    xoops_load('XoopsLocal');
    $tpl->assign('channel_title', XoopsLocal::convert_encoding(htmlspecialchars($xoopsConfig['sitename'], ENT_QUOTES)));
    $tpl->assign('channel_link', XOOPS_URL . '/');
    $tpl->assign('channel_desc', XoopsLocal::convert_encoding(htmlspecialchars($xoopsConfig['slogan'], ENT_QUOTES)));
    $tpl->assign('channel_lastbuild', formatTimestamp(time(), 'rss'));
    $tpl->assign('channel_webmaster', checkEmail($xoopsConfig['adminmail'], true));
    $tpl->assign('channel_editor', checkEmail($xoopsConfig['adminmail'], true));
    $tpl->assign('channel_category', 'News');
    $tpl->assign('channel_generator', 'XOOPS');
    $tpl->assign('channel_language', _LANGCODE);
    $tpl->assign('image_url', XOOPS_URL . '/images/logo.png');
    $dimention = getimagesize(XOOPS_ROOT_PATH . '/images/logo.png');
    if (empty($dimention[0])) {
        $width = 88;
    } else {
        $width = ($dimention[0] > 144) ? 144 : $dimention[0];
    }
    if (empty($dimention[1])) {
        $height = 31;
    } else {
        $height = ($dimention[1] > 400) ? 400 : $dimention[1];
    }
    $tpl->assign('image_width', $width);
    $tpl->assign('image_height', $height);
    
    $sql="select ncsn,nc_title from ".$xoopsDB->prefix("tad_news_cate")." where not_news!='1' and enable_group=''";
  	$result=$xoopsDB->query($sql) or redirect_header($_SERVER['PHP_SELF'],3, mysql_error());
  	while(list($ncsn,$nc_title)=$xoopsDB->fetchRow($result)){
  		$ncsn_ok[]=$ncsn;
  		$cates[$ncsn]=$nc_title;
  	}

  	$ok_cate=implode(",",$ncsn_ok);
  	$where_cate=(empty($ok_cate))?"and ncsn='0'":"and (ncsn in($ok_cate) or ncsn='0')";

  	$sql = "select * from ".$xoopsDB->prefix("tad_news")." where enable='1' and passwd='' and enable_group='' $where_cate and start_day < '{$today}' and (end_day > '{$today}' or end_day='0000-00-00 00:00:00') order by $top_order start_day desc limit 0 , 30";
  	
  	$result = $xoopsDB->query($sql) or redirect_header(XOOPS_URL,3,mysql_error());
    while($all_news=$xoopsDB->fetchArray($result)){
  	  foreach($all_news as $k=>$v){
  			$$k=$v;
  		}
  		
  		
  		$tpl->append('items', array(
                  'title' => XoopsLocal::convert_encoding(htmlspecialchars($news_title, ENT_QUOTES)) ,
                  'link' => XOOPS_URL . '/modules/tadnews/index.php?nsn=' . $nsn ,
                  'guid' => XOOPS_URL . '/modules/tadnews/index.php?ncsn=' . $ncsn ,
                  'pubdate' => formatTimestamp(strtotime($start_day), 'rss') ,
                  'description' => XoopsLocal::convert_encoding(htmlspecialchars($news_content, ENT_QUOTES))));
		}
}
$tpl->display('db:system_rss.html');
?>
