/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import wjhk.jupload2.exception.JUploadException;
import wjhk.jupload2.policies.UploadPolicy;

public class DialogUploadRetry
extends JDialog
implements ActionListener,
ComponentListener {
    JButton buttonYes;
    JButton buttonNo;
    JButton buttonDetails;
    JTextArea jtextArea;
    JTextArea detailTestArea;
    JUploadException juploadException = null;
    UploadPolicy uploadPolicy = null;
    Timer countdownTimer = null;
    int countdownValue;
    boolean retryValidated = false;

    public DialogUploadRetry(Frame owner, JUploadException juploadException, int numRetry, UploadPolicy uploadPolicy) throws JUploadException {
        super(owner, uploadPolicy.getLocalizedString("dialogUploadRetryTitle", new Object[0]), true);
        this.uploadPolicy = uploadPolicy;
        this.juploadException = juploadException;
        double retryDelayFactor = Math.pow(1.5, numRetry);
        this.countdownValue = (int)((double)uploadPolicy.getRetryNbSecondsBetween() * retryDelayFactor);
        this.countdownTimer = new Timer(1000, this);
        this.countdownTimer.start();
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    DialogUploadRetry.this.createGUI();
                }
            });
        }
        catch (InterruptedException e) {
            throw new JUploadException("Error while creating the " + this.getClass().getName(), e.getCause());
        }
        catch (InvocationTargetException e) {
            throw new JUploadException("Error while creating the " + this.getClass().getName(), e.getCause());
        }
        this.setVisible(true);
    }

    public boolean isRetryValidated() {
        return this.retryValidated;
    }

    private void createGUI() {
        JPanel jPanelText = new JPanel();
        this.jtextArea = new JTextArea(this.uploadPolicy.getLocalizedString("dialogUploadRetryText", this.countdownValue));
        this.jtextArea.setEditable(false);
        this.jtextArea.setMinimumSize(new Dimension(400, 100));
        this.jtextArea.setBackground(jPanelText.getBackground());
        jPanelText.add(this.jtextArea);
        this.getContentPane().add((Component)jPanelText, "Center");
        this.buttonYes = new JButton(this.uploadPolicy.getLocalizedString("buttonYes", new Object[0]));
        this.buttonYes.setMinimumSize(new Dimension(80, 30));
        this.buttonYes.setMaximumSize(new Dimension(100, 100));
        this.buttonYes.addActionListener(this);
        this.buttonNo = new JButton(this.uploadPolicy.getLocalizedString("buttonNo", new Object[0]));
        this.buttonNo.setMinimumSize(new Dimension(80, 30));
        this.buttonNo.setMaximumSize(new Dimension(100, 100));
        this.buttonNo.addActionListener(this);
        this.buttonDetails = new JButton(this.uploadPolicy.getLocalizedString("buttonDetails", new Object[0]));
        this.buttonDetails.setMinimumSize(new Dimension(80, 30));
        this.buttonDetails.setMaximumSize(new Dimension(100, 100));
        this.buttonDetails.addActionListener(this);
        JPanel jPanelButton = new JPanel();
        jPanelButton.setLayout(new BoxLayout(jPanelButton, 2));
        jPanelButton.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        jPanelButton.add(Box.createHorizontalGlue());
        jPanelButton.add(this.buttonYes);
        jPanelButton.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanelButton.add(this.buttonNo);
        jPanelButton.add(Box.createRigidArea(new Dimension(10, 0)));
        jPanelButton.add(this.buttonDetails);
        JPanel jPanelDetail = new JPanel();
        this.detailTestArea = new JTextArea(this.juploadException.getMessage());
        this.detailTestArea.setEditable(false);
        this.detailTestArea.setMinimumSize(new Dimension(400, 500));
        this.detailTestArea.setBackground(jPanelDetail.getBackground());
        jPanelDetail.add(this.detailTestArea);
        this.getContentPane().add((Component)jPanelDetail, "Center");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 3));
        mainPanel.add(this.jtextArea);
        mainPanel.add(jPanelButton);
        mainPanel.add(jPanelDetail);
        this.getContentPane().add(mainPanel);
        this.getRootPane().setDefaultButton(this.buttonYes);
        this.pack();
        this.detailTestArea.setVisible(false);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.countdownTimer) {
            --this.countdownValue;
            if (this.countdownValue <= 0) {
                this.disposeDialog(true);
            } else {
                this.jtextArea.setText(this.uploadPolicy.getLocalizedString("dialogUploadRetryText", this.countdownValue));
            }
        } else if (event.getActionCommand() == this.buttonDetails.getActionCommand()) {
            this.uploadPolicy.displayDebug("[DialogUploadRetry] User choose to display or hide details", 10);
            this.detailTestArea.setVisible(!this.detailTestArea.isVisible());
            if (this.detailTestArea.isVisible()) {
                this.detailTestArea.setMinimumSize(new Dimension(400, 500));
                this.detailTestArea.setMaximumSize(new Dimension(400, 500));
            } else {
                this.detailTestArea.setMinimumSize(new Dimension(0, 0));
                this.detailTestArea.setMaximumSize(new Dimension(0, 0));
            }
        } else if (event.getActionCommand() == this.buttonNo.getActionCommand()) {
            this.uploadPolicy.displayDebug("[DialogUploadRetry] User choose buttonNo", 10);
            this.disposeDialog(false);
        } else if (event.getActionCommand() == this.buttonYes.getActionCommand()) {
            this.uploadPolicy.displayDebug("[DialogUploadRetry] User choose buttonYes", 10);
            this.disposeDialog(true);
        }
    }

    private void disposeDialog(boolean retryValidated) {
        this.retryValidated = retryValidated;
        this.countdownTimer.stop();
        this.dispose();
    }

    public void componentHidden(ComponentEvent arg0) {
    }

    public void componentMoved(ComponentEvent arg0) {
    }

    public void componentResized(ComponentEvent arg0) {
    }

    public void componentShown(ComponentEvent arg0) {
        this.setCursor(new Cursor(12));
    }
}

