/*
 * Decompiled with CFR 0.152.
 */
package wjhk.jupload2.gui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import wjhk.jupload2.filedata.DefaultFileData;
import wjhk.jupload2.gui.JUploadPanel;
import wjhk.jupload2.policies.UploadPolicy;

class JUploadTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = -1241261479500810699L;
    DataFlavor fileListFlavor = DataFlavor.javaFileListFlavor;
    DataFlavor uriListFlavor;
    JUploadPanel uploadPanel = null;
    UploadPolicy uploadPolicy = null;

    public JUploadTransferHandler(UploadPolicy uploadPolicy, JUploadPanel uploadPanel) {
        this.uploadPolicy = uploadPolicy;
        this.uploadPanel = uploadPanel;
        try {
            this.uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
        }
        catch (ClassNotFoundException ex) {
            this.uriListFlavor = DataFlavor.javaFileListFlavor;
        }
    }

    public boolean importData(JComponent c, Transferable t) {
        DataFlavor[] flavors = t.getTransferDataFlavors();
        boolean importAccepted = false;
        if (this.canImport(c, flavors)) {
            try {
                List<File> fileList = new ArrayList();
                if (this.isFile(flavors)) {
                    fileList = (List)t.getTransferData(this.fileListFlavor);
                    importAccepted = true;
                } else if (this.isUrl(flavors)) {
                    String uriStr;
                    Reader in = this.uriListFlavor.getReaderForText(t);
                    BufferedReader br = new BufferedReader(in);
                    while ((uriStr = br.readLine()) != null) {
                        try {
                            fileList.add(new File(new URI(uriStr)));
                        }
                        catch (URISyntaxException use) {
                            this.uploadPolicy.displayErr(this.getClass().getName() + ".importData()", use);
                        }
                    }
                    importAccepted = true;
                }
                File[] fileArray = fileList.toArray(new File[fileList.size()]);
                this.uploadPanel.getFilePanel().addFiles(fileArray, DefaultFileData.getRoot(fileArray));
                return importAccepted;
            }
            catch (UnsupportedFlavorException ufe) {
                this.uploadPolicy.displayErr(this.getClass().getName() + ".importData()", ufe);
            }
            catch (IOException ioe) {
                this.uploadPolicy.displayErr(this.getClass().getName() + ".importData()", ioe);
            }
        }
        return importAccepted;
    }

    public int getSourceActions(JComponent c) {
        return 2;
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        return this.isFile(flavors) || this.isUrl(flavors);
    }

    protected boolean isFile(DataFlavor[] flavors) {
        for (DataFlavor flavor : flavors) {
            if (!this.fileListFlavor.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    protected boolean isUrl(DataFlavor[] flavors) {
        for (DataFlavor flavor : flavors) {
            if (!this.uriListFlavor.equals(flavor)) continue;
            return true;
        }
        return false;
    }
}

