CREATE TABLE `tad_account` (
  `account_sn` smallint(6) unsigned NOT NULL auto_increment COMMENT '帳目編號',
  `account_date` date NOT NULL COMMENT '日期',
  `income` mediumint(9) unsigned NOT NULL default 0 COMMENT '收入',
  `expenditure` mediumint(9) unsigned NOT NULL default 0 COMMENT '支出',
  `account_title` varchar(255) NOT NULL default '' COMMENT '項目名稱',
  `account_note` text NOT NULL COMMENT '備註',
  `uid` smallint(6) unsigned NOT NULL default 0 COMMENT '經手人',
  `account_book_sn` tinyint(3) unsigned NOT NULL default 0 COMMENT '帳簿編號',
PRIMARY KEY (`account_sn`)
) ENGINE=MyISAM;

CREATE TABLE `tad_account_book` (
  `account_book_sn` tinyint(3) unsigned NOT NULL auto_increment COMMENT '帳簿編號',
  `account_book_title` varchar(255) NOT NULL default '' COMMENT '帳簿名稱',
  `account_book_date` datetime NOT NULL COMMENT '建立日期',
  `uid` smallint(6) unsigned NOT NULL default 0 COMMENT '建立者',
  `account_book_group` varchar(255) NOT NULL default '' COMMENT '可讀取群組',
  `account_book_manager` varchar(255) NOT NULL default '' COMMENT '可記帳者',
PRIMARY KEY (`account_book_sn`)
) ENGINE=MyISAM;

